
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="cornichons", lb=0, ub=147/11, vtype=gurobi.GRB.CONTINUOUS)
x2 = model.addVar(name="strips of bacon", lb=0, ub=147/8, vtype=gurobi.GRB.CONTINUOUS)
x3 = model.addVar(name="bananas", lb=0, ub=147/3, vtype=gurobi.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(4.4 * x1 + 9.0 * x2 + 8.18 * x3, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(8 * x2 + 3 * x3 >= 41, name="tastiness_bacon_bananas")
model.addConstr(11 * x1 + 8 * x2 >= 18, name="tastiness_cornichons_bacon")
model.addConstr(11 * x1 + 8 * x2 + 3 * x3 >= 18, name="tastiness_all")
model.addConstr(2 * x1 - 8 * x2 >= 0, name="cornichons_bacon_ratio")
model.addConstr(-x2 + 7 * x3 >= 0, name="bacon_bananas_ratio")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("cornichons: ", x1.varValue)
    print("strips of bacon: ", x2.varValue)
    print("bananas: ", x3.varValue)
else:
    print("The model is infeasible")
