
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_model")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")  # hours worked by Bill
    x1 = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x1")  # hours worked by Peggy


    # Set objective function
    model.setObjective(8.39*x0**2 + 8.27*x0*x1 + 9.56*x1**2 + 8.29*x0 + 9.12*x1, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(15*x0 + 2*x1 >= 43, "c0")
    model.addConstr(21*x0**2 + 9*x1**2 >= 40, "c1")
    model.addConstr(4*x0 + 26*x1 >= 27, "c2")
    model.addConstr(9*x0**2 - 6*x1**2 >= 0, "c3")
    model.addConstr(15*x0**2 + 2*x1**2 <= 67, "c4")
    model.addConstr(21*x0**2 + 9*x1**2 <= 99, "c5")
    model.addConstr(4*x0 + 26*x1 <= 106, "c6")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"x0 (hours worked by Bill): {x0.x}")
        print(f"x1 (hours worked by Peggy): {x1.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Gurobi Error: {e}")

except AttributeError:
    print("Encountered an attribute error. Check if the model optimized successfully.")

