
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(lb=0, name="hours_worked_by_Bill")  # No upper bound given, assuming continuous
    x1 = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="hours_worked_by_Peggy")
    
    # Objective function
    model.setObjective(8.39*x0**2 + 8.27*x0*x1 + 9.56*x1**2 + 8.29*x0 + 9.12*x1, gurobi.GRB.MINIMIZE)
    
    # Constraints
    model.addConstr(15*x0 + 2*x1 >= 43)
    model.addConstr(21*x0**2 + 9*x1**2 >= 40)
    model.addConstr(4*x0**2 + 26*x1**2 >= 27)
    model.addConstr(9*x0**2 - 6*x1**2 >= 0)
    model.addConstr(225*x0**2 + 4*x1**2 <= 67)
    model.addConstr(441*x0**2 + 81*x1**2 <= 99)
    model.addConstr(4*x0 + 26*x1 <= 106)
    
    # Optimize
    model.optimize()
    
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Bill: {x0.varValue}")
        print(f"Hours worked by Peggy: {x1.varValue}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
