
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x = m.addVars(4, lb=0, vtype=gp.GRB.CONTINUOUS, names=["x0", "x1", "x2", "x3"])


    # Set objective function
    m.setObjective(5.08*x[0] + 8.0*x[1] + 2.06*x[2] + 6.52*x[3], gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(28*x[2] + 6*x[3] >= 74)
    m.addConstr(2*x[0] + 18*x[1] >= 78)
    m.addConstr(2*x[0] + 28*x[2] + 6*x[3] >= 73)
    m.addConstr(2*x[0] + 18*x[1] + 28*x[2] + 6*x[3] >= 73)
    m.addConstr(15*x[0] + 23*x[1] >= 40)
    m.addConstr(23*x[1] + 26*x[2] >= 29)
    m.addConstr(15*x[0] + 9*x[3] >= 41)
    m.addConstr(15*x[0] + 23*x[1] + 26*x[2] + 9*x[3] >= 41)
    m.addConstr(8*x[2] - 5*x[3] >= 0)
    m.addConstr(18*x[1] + 28*x[2] <= 252)
    m.addConstr(18*x[1] + 6*x[3] <= 330)
    m.addConstr(28*x[2] + 6*x[3] <= 271)
    m.addConstr(2*x[0] + 18*x[1] <= 468)
    m.addConstr(2*x[0] + 6*x[3] <= 355)
    m.addConstr(18*x[1] + 28*x[2] + 6*x[3] <= 282)
    m.addConstr(2*x[0] + 18*x[1] + 28*x[2] <= 235)
    m.addConstr(23*x[1] + 26*x[2] + 9*x[3] <= 128)
    m.addConstr(15*x[0] + 26*x[2] + 9*x[3] <= 214)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for i in range(4):
            print(f"x{i}: {x[i].x}")
        print(f"Objective Value: {m.objVal}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
