
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Jean
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Peggy
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Paul
    x3 = model.addVar(name="x3", lb=0)  # hours worked by George

    # Objective function
    model.setObjective(5.08*x0 + 8.0*x1 + 2.06*x2 + 6.52*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(28*x2 + 6*x3 >= 74)
    model.addConstr(2*x0 + 18*x1 >= 78)
    model.addConstr(2*x0 + 28*x2 + 6*x3 >= 73)
    model.addConstr(2*x0 + 18*x1 + 28*x2 + 6*x3 >= 73)
    model.addConstr(15*x0 + 23*x1 >= 40)
    model.addConstr(23*x1 + 26*x2 >= 29)
    model.addConstr(15*x0 + 9*x3 >= 41)
    model.addConstr(15*x0 + 23*x1 + 26*x2 + 9*x3 >= 41)
    model.addConstr(8*x2 - 5*x3 >= 0)
    model.addConstr(18*x1 + 28*x2 <= 252)
    model.addConstr(18*x1 + 6*x3 <= 330)
    model.addConstr(28*x2 + 6*x3 <= 271)
    model.addConstr(2*x0 + 18*x1 <= 468)
    model.addConstr(2*x0 + 6*x3 <= 355)
    model.addConstr(18*x1 + 28*x2 + 6*x3 <= 282)
    model.addConstr(2*x0 + 18*x1 + 28*x2 <= 235)
    model.addConstr(23*x1 + 26*x2 + 9*x3 <= 128)
    model.addConstr(15*x0 + 26*x2 + 9*x3 <= 214)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
