
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    hank = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")
    laura = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura")
    bobby = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby")
    george = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="george")


    # Set objective function
    model.setObjective(1.49 * hank + 2.46 * laura + 7.06 * bobby + 6.37 * george, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(2 * laura + 6 * bobby >= 11, "c1")
    model.addConstr(2 * laura + 8 * george >= 10, "c2")
    model.addConstr(2 * hank + 6 * bobby >= 10, "c3")
    model.addConstr(2 * hank + 6 * bobby + 8 * george >= 8, "c4")
    model.addConstr(2 * hank + 2 * laura + 8 * george >= 8, "c5")
    model.addConstr(2 * hank + 6 * bobby + 8 * george >= 9, "c6")
    model.addConstr(2 * hank + 2 * laura + 8 * george >= 9, "c7")
    model.addConstr(2 * hank - 9 * bobby - 9 * george >= 0, "c8")
    model.addConstr(6 * bobby + 8 * george <= 19, "c9")
    model.addConstr(2 * hank + 8 * george <= 12, "c10")
    model.addConstr(2 * hank + 6 * bobby + 8 * george <= 12, "c11")
    model.addConstr(2 * laura + 6 * bobby + 8 * george <= 20, "c12")
    model.addConstr(2 * hank + 2 * laura + 8 * george <= 36, "c13")
    model.addConstr(2 * hank + 2 * laura + 6 * bobby + 8 * george <= 36, "c14")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
