
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="x1", lb=0, ub=None) # hours worked by Hank
x2 = m.addVar(name="x2", lb=0, ub=None) # hours worked by Laura
x3 = m.addVar(name="x3", lb=0, ub=None) # hours worked by Bobby
x4 = m.addVar(name="x4", lb=0, ub=None) # hours worked by George

# Objective function
m.setObjective(1.49*x1 + 2.46*x2 + 7.06*x3 + 6.37*x4, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 == 1, name="Hank_organization_score")
m.addConstr(x2 == 1, name="Laura_organization_score")
m.addConstr(x3 == 1, name="Bobby_organization_score")
m.addConstr(x4 == 1, name="George_organization_score")

m.addConstr(2*x2 + 6*x3 >= 11, name="Laura_Bobby_organization_score")
m.addConstr(2*x2 + 8*x4 >= 10, name="Laura_George_organization_score")
m.addConstr(2*x1 + 6*x3 >= 10, name="Hank_Bobby_organization_score")
m.addConstr(2*x1 + 6*x3 + 8*x4 >= 8, name="Hank_Bobby_George_organization_score")
m.addConstr(2*x1 + 2*x2 + 8*x4 >= 8, name="Hank_Laura_George_organization_score")
m.addConstr(2*x1 + 6*x3 + 8*x4 >= 9, name="Hank_Bobby_George_organization_score_2")
m.addConstr(2*x1 + 2*x2 + 8*x4 >= 9, name="Hank_Laura_George_organization_score_2")

m.addConstr(2*x1 - 9*x3 - 9*x4 >= 0, name="Hank_Bobby_George_organization_score_diff")

m.addConstr(6*x3 + 8*x4 <= 19, name="Bobby_George_organization_score_max")
m.addConstr(2*x1 + 8*x4 <= 12, name="Hank_George_organization_score_max")
m.addConstr(2*x1 + 6*x3 + 8*x4 <= 12, name="Hank_Bobby_George_organization_score_max")
m.addConstr(2*x2 + 6*x3 + 8*x4 <= 20, name="Laura_Bobby_George_organization_score_max")
m.addConstr(2*x1 + 2*x2 + 8*x4 <= 36, name="Hank_Laura_George_organization_score_max")
m.addConstr(2*x1 + 2*x2 + 6*x3 + 8*x4 <= 36, name="All_organization_score_max")

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Hank: ", x1.varValue)
    print("Hours worked by Laura: ", x2.varValue)
    print("Hours worked by Bobby: ", x3.varValue)
    print("Hours worked by George: ", x4.varValue)
else:
    print("The model is infeasible")
