
import gurobipy as gp

# Create a new model
model = gp.Model("Maximize Food Value")

# Create variables
bagged_salads = model.addVar(vtype=gp.GRB.INTEGER, name="bagged_salads")
pickles = model.addVar(vtype=gp.GRB.INTEGER, name="pickles")

# Set objective function
model.setObjective(8.18 * bagged_salads + 6.68 * pickles, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(9 * bagged_salads + 8 * pickles >= 57, "protein_min")
model.addConstr(1 * bagged_salads + 2 * pickles >= 69, "fat_min")
model.addConstr(-7 * bagged_salads + 4 * pickles >= 0, "salad_pickle_ratio")
model.addConstr(9 * bagged_salads + 8 * pickles <= 60, "protein_max")
model.addConstr(1 * bagged_salads + 2 * pickles <= 158, "fat_max")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print("Optimal Solution:")
    print(f"Bagged Salads: {bagged_salads.x}")
    print(f"Pickles: {pickles.x}")
    print(f"Objective Value: {model.objVal}")

