
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x0 = m.addVar(vtype=GRB.INTEGER, name="bagged_salads")
x1 = m.addVar(vtype=GRB.INTEGER, name="pickles")

# Set the objective function
m.setObjective(8.18*x0 + 6.68*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(9*x0 + 8*x1 >= 57, "protein_min")
m.addConstr(x0 + 2*x1 >= 69, "fat_min")
m.addConstr(-7*x0 + 4*x1 >= 0, "linear_ineq")
m.addConstr(9*x0 + 8*x1 <= 60, "protein_max")
m.addConstr(x0 + 2*x1 <= 158, "fat_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bagged Salads: {x0.x}")
    print(f"Pickles: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
