
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="bagged_salads", vtype=gurobi.GRB.INTEGER)  # Integer number of bagged salads
    x2 = model.addVar(name="pickles", vtype=gurobi.GRB.INTEGER)  # Integer number of pickles

    # Objective function: Maximize 8.18*x1 + 6.68*x2
    model.setObjective(8.18 * x1 + 6.68 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(9 * x1 + 8 * x2 >= 57, name="min_protein")
    model.addConstr(x1 + 2 * x2 >= 69, name="min_fat")
    model.addConstr(-7 * x1 + 4 * x2 >= 0, name="linear_constraint")
    model.addConstr(9 * x1 + 8 * x2 <= 60, name="max_protein")
    model.addConstr(x1 + 2 * x2 <= 158, name="max_fat")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Bagged Salads: {x1.varValue}")
        print(f"Pickles: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
