
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    protein = m.addVar(lb=0, name="protein")
    b12 = m.addVar(lb=0, name="b12")
    vitamin_c = m.addVar(lb=0, name="vitamin_c")


    # Set objective function
    m.setObjective(5*protein**2 + 3*b12*vitamin_c + 9*vitamin_c**2 + 5*protein + 7*vitamin_c, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(2*protein + 14*b12 + 27*vitamin_c >= 85, "kidney_support_min")
    m.addConstr(2*protein + 14*b12 <= 227, "kidney_support_protein_b12_max")
    m.addConstr(2*protein + 27*vitamin_c <= 117, "kidney_support_protein_vitaminc_max")
    m.addConstr(2*protein + 14*b12 + 27*vitamin_c <= 326, "kidney_support_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Protein: %g' % protein.x)
        print('B12: %g' % b12.x)
        print('Vitamin C: %g' % vitamin_c.x)
    elif m.status == GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

