
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="grams_of_protein")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B12")
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_C")

# Define the objective function
m.setObjective(5*x1**2 + 3*x2*x3 + 9*x3**2 + 5*x1 + 7*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + 14*x2 + 27*x3 >= 85, "kidney_support_index_all")
m.addConstr(2*x1 + 14*x2 <= 227, "kidney_support_index_protein_B12")
m.addConstr(2*x1 + 27*x3 <= 117, "kidney_support_index_protein_C")
m.addConstr(2*x1 + 14*x2 + 27*x3 <= 326, "total_kidney_support_index")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grams of Protein: {x1.x}")
    print(f"Milligrams of Vitamin B12: {x2.x}")
    print(f"Milligrams of Vitamin C: {x3.x}")
else:
    print("No optimal solution found")
