
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="grams_of_protein")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams_of_vitamin_B12")
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams_of_vitamin_C")

    # Define the objective function
    model.setObjective(5*x1**2 + 3*x2*x3 + 9*x3**2 + 5*x1 + 7*x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(2*x1 + 14*x2 + 27*x3 >= 85, name="combined_kidney_support_index")
    model.addConstr(2*x1 + 14*x2 <= 227, name="protein_B12_kidney_support")
    model.addConstr(2*x1 + 27*x3 <= 117, name="protein_C_kidney_support")
    model.addConstr(2*x1 + 14*x2 + 27*x3 <= 326, name="total_kidney_support")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Grams of protein: {x1.varValue}")
        print(f"Milligrams of vitamin B12: {x2.varValue}")
        print(f"Milligrams of vitamin C: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
