
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
hamburgers = m.addVar(lb=0, name="hamburgers")
ham_sandwiches = m.addVar(lb=0, name="ham_sandwiches")
strawberries = m.addVar(lb=0, name="strawberries")
hot_dogs = m.addVar(lb=0, name="hot_dogs")
green_beans = m.addVar(lb=0, name="green_beans")
oranges = m.addVar(lb=0, name="oranges")

# Set objective function
m.setObjective(7.24 * hamburgers + 8.67 * ham_sandwiches + 5.02 * strawberries + 8.69 * hot_dogs + 4.33 * green_beans + 3.76 * oranges, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1 * hamburgers + 2 * ham_sandwiches + 7 * strawberries + 6 * hot_dogs + 1 * green_beans + 2 * oranges <= 139, "dollar_cost")
m.addConstr(2 * ham_sandwiches + 7 * strawberries >= 17, "c1")
m.addConstr(2 * ham_sandwiches + 6 * hot_dogs >= 18, "c2")
m.addConstr(6 * hot_dogs + 2 * oranges >= 14, "c3")
m.addConstr(7 * strawberries + 6 * hot_dogs >= 7, "c4")
m.addConstr(1 * hamburgers + 2 * oranges >= 18, "c5")
m.addConstr(6 * hot_dogs + 1 * green_beans >= 17, "c6")
m.addConstr(1 * hamburgers + 7 * strawberries >= 13, "c7")
m.addConstr(1 * hamburgers + 2 * ham_sandwiches >= 23, "c8")
m.addConstr(6 * hot_dogs + 1 * green_beans <= 138, "c9")
m.addConstr(2 * ham_sandwiches + 1 * green_beans <= 57, "c10")
m.addConstr(1 * hamburgers + 2 * ham_sandwiches <= 50, "c11")
m.addConstr(7 * strawberries + 6 * hot_dogs <= 122, "c12")
m.addConstr(6 * hot_dogs + 2 * oranges <= 138, "c13")
m.addConstr(1 * hamburgers + 2 * oranges <= 129, "c14")
m.addConstr(7 * strawberries + 2 * oranges <= 121, "c15")
m.addConstr(7 * strawberries + 1 * green_beans <= 122, "c16")
m.addConstr(2 * ham_sandwiches + 2 * oranges <= 48, "c17")
m.addConstr(1 * hamburgers + 2 * ham_sandwiches + 7 * strawberries + 6 * hot_dogs + 1 * green_beans + 2 * oranges <= 48, "c18")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

