
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='hamburgers', lb=0, ub=None)
x2 = m.addVar(name='ham sandwiches', lb=0, ub=None)
x3 = m.addVar(name='strawberries', lb=0, ub=None)
x4 = m.addVar(name='hot dogs', lb=0, ub=None)
x5 = m.addVar(name='green beans', lb=0, ub=None)
x6 = m.addVar(name='oranges', lb=0, ub=None)

# Objective function
m.setObjective(7.24*x1 + 8.67*x2 + 5.02*x3 + 8.69*x4 + 4.33*x5 + 3.76*x6, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(1*x1 + 2*x2 + 7*x3 + 6*x4 + 1*x5 + 2*x6 <= 139)
m.addConstr(2*x2 + 7*x3 >= 17)
m.addConstr(2*x2 + 6*x4 >= 18)
m.addConstr(6*x4 + 2*x6 >= 14)
m.addConstr(7*x3 + 6*x4 >= 7)
m.addConstr(x1 + 2*x6 >= 18)
m.addConstr(6*x4 + x5 >= 17)
m.addConstr(x1 + 7*x3 >= 13)
m.addConstr(x1 + 2*x2 >= 23)
m.addConstr(6*x4 + x5 <= 138)
m.addConstr(2*x2 + x5 <= 57)
m.addConstr(x1 + 2*x2 <= 50)
m.addConstr(7*x3 + 6*x4 <= 122)
m.addConstr(6*x4 + 2*x6 <= 138)
m.addConstr(x1 + 2*x6 <= 129)
m.addConstr(7*x3 + 2*x6 <= 121)
m.addConstr(7*x3 + x5 <= 122)
m.addConstr(2*x2 + 2*x6 <= 48)
m.addConstr(x1 + 2*x2 + 7*x3 + 6*x4 + x5 + 2*x6 <= 48)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('hamburgers: ', x1.varValue)
    print('ham sandwiches: ', x2.varValue)
    print('strawberries: ', x3.varValue)
    print('hot dogs: ', x4.varValue)
    print('green beans: ', x5.varValue)
    print('oranges: ', x6.varValue)
else:
    print('No solution found')
