
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B5
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin B1
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of vitamin K
    x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3") # milligrams of iron


    # Set objective function
    m.setObjective(7*x0 + 9*x1 + 6*x2 + 6*x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(18*x0 + 15*x1 >= 19)
    m.addConstr(15*x1 + 6*x2 >= 32)
    m.addConstr(15*x1 + 6*x2 + 13*x3 >= 26)
    m.addConstr(18*x0 + 6*x2 + 13*x3 >= 26)
    m.addConstr(18*x0 + 15*x1 + 6*x2 + 13*x3 >= 26)
    m.addConstr(13*x0 + 14*x3 >= 37)
    m.addConstr(13*x0 + 1*x1 + 13*x2 + 14*x3 >= 37)
    m.addConstr(7*x2 + 17*x3 >= 20)
    m.addConstr(11*x0 + 7*x2 >= 9)
    m.addConstr(4*x1 + 17*x3 >= 11)
    m.addConstr(11*x0 + 4*x1 + 7*x2 >= 25)
    m.addConstr(4*x1 + 7*x2 + 17*x3 >= 25)
    m.addConstr(11*x0 + 4*x1 + 7*x2 + 17*x3 >= 19)
    m.addConstr(-10*x1 + x2 >= 0)
    m.addConstr(6*x2 + 13*x3 <= 168)
    m.addConstr(x1 + 13*x2 <= 96)
    m.addConstr(4*x1 + 7*x2 + 17*x3 <= 77)

    # Resource Constraints
    m.addConstr(18*x0 <= 193)
    m.addConstr(13*x0 <= 160)
    m.addConstr(11*x0 <= 110)
    m.addConstr(15*x1 <= 193)
    m.addConstr(1*x1 <= 160)
    m.addConstr(4*x1 <= 110)
    m.addConstr(6*x2 <= 193)
    m.addConstr(13*x2 <= 160)
    m.addConstr(7*x2 <= 110)
    m.addConstr(13*x3 <= 193)
    m.addConstr(14*x3 <= 160)
    m.addConstr(17*x3 <= 110)



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Objective Value:', m.objVal)
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
