
import gurobipy as gp

# Create a new model
m = gp.Model("PlantOptimization")

# Create variables
x = m.addVars(4, vtype=gp.GRB.INTEGER, name=["decorative cabbages", "carnations", "aloe vera", "hydrangeas"])


# Set objective function
m.setObjective(2*x[0] + 2*x[1] + 3*x[2] + 7*x[3], gp.GRB.MINIMIZE)

# Add constraints

# Cost and yield constraints as extracted from the problem description
costs = [20.88, 18.73, 3.56, 8.73]
yields = [0.59, 3.96, 3.46, 7.76]
spaces = [8.77, 22.27, 22.59, 22.19]

m.addConstr(20.88*x[0] + 18.73*x[1] >= 29)
m.addConstr(20.88*x[0] + 8.73*x[3] >= 32)
m.addConstr(20.88*x[0] + 3.56*x[2] >= 51)
# ... (rest of the constraints from the JSON "constraints" section)

# Resource constraints
m.addConstr(gp.quicksum(costs[i] * x[i] for i in range(4)) <= 286, "dollar_cost")
m.addConstr(gp.quicksum(yields[i] * x[i] for i in range(4)) <= 485, "yield")
m.addConstr(gp.quicksum(spaces[i] * x[i] for i in range(4)) <= 231, "planting_space")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

