
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype='C', name='vitamin_D')
    x1 = m.addVar(lb=0, vtype='C', name='vitamin_B1')
    x2 = m.addVar(lb=0, vtype='C', name='zinc')
    x3 = m.addVar(lb=0, vtype='C', name='vitamin_B5')


    # Set objective function
    m.setObjective(2.02*x0 + 6.45*x1 + 5.51*x2 + 2.96*x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(14*x0 + 6*x1 >= 24, "c1")
    m.addConstr(14*x0 + 16*x3 >= 23, "c2")
    m.addConstr(14*x0 + 15*x2 <= 75, "c3")
    m.addConstr(6*x1 + 15*x2 <= 77, "c4")
    m.addConstr(15*x2 + 16*x3 <= 63, "c5")
    m.addConstr(14*x0 + 6*x1 + 15*x2 + 16*x3 <= 63, "c6")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GrorbiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

