
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables (all are continuous)
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="vitamin_D")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="vitamin_B1")
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="zinc")
x4 = m.addVar(vtype=GRB.CONTINUOUS, name="vitamin_B5")

# Set the objective function
m.setObjective(2.02*x1 + 6.45*x2 + 5.51*x3 + 2.96*x4, GRB.MAXIMIZE)

# Add constraints
m.addConstr(14*x1 + 6*x2 >= 24)
m.addConstr(14*x1 + 16*x4 >= 23)
m.addConstr(14*x1 + 15*x3 <= 75)
m.addConstr(6*x2 + 15*x3 <= 77)
m.addConstr(15*x3 + 16*x4 <= 63)
m.addConstr(14*x1 + 6*x2 + 15*x3 + 16*x4 <= 112)

# Optimize model
m.optimize()

# Print solution
for v in m.getVars():
    print('%s %g' % (v.varName, v.x))

print('Obj: %g' % m.objVal)
