
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="milligrams of vitamin D", lb=-float('inf'))
    x2 = model.addVar(name="milligrams of vitamin B1", lb=-float('inf'))
    x3 = model.addVar(name="milligrams of zinc", lb=-float('inf'))
    x4 = model.addVar(name="milligrams of vitamin B5", lb=-float('inf'))

    # Define the objective function
    model.setObjective(2.02*x1 + 6.45*x2 + 5.51*x3 + 2.96*x4, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(14*x1 + 6*x2 >= 24)
    model.addConstr(14*x1 + 16*x4 >= 23)
    model.addConstr(14*x1 + 15*x3 <= 75)
    model.addConstr(6*x2 + 15*x3 <= 77)
    model.addConstr(15*x3 + 16*x4 <= 63)
    model.addConstr(14*x1 + 6*x2 + 15*x3 + 16*x4 <= 112)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin D: {x1.varValue}")
        print(f"Milligrams of vitamin B1: {x2.varValue}")
        print(f"Milligrams of zinc: {x3.varValue}")
        print(f"Milligrams of vitamin B5: {x4.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
