
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of calcium
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # grams of fiber
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # grams of protein


    # Set objective function
    m.setObjective(3*x0 + 1*x1 + 3*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3.18*x0 + 7.91*x1 >= 16)
    m.addConstr(6.97*x1 + 7.41*x2 >= 15)
    m.addConstr(7.91*x1 + 1.06*x2 <= 57)
    m.addConstr(3.18*x0 + 7.91*x1 <= 90)
    m.addConstr(3.18*x0 + 7.91*x1 + 1.06*x2 <= 90)
    m.addConstr(3.69*x0 + 7.41*x2 <= 37)
    m.addConstr(6.97*x1 + 7.41*x2 <= 57)
    m.addConstr(3.69*x0 + 6.97*x1 + 7.41*x2 <= 57)
    m.addConstr(7.56*x0 + 2.11*x1 <= 35)
    m.addConstr(7.56*x0 + 1.96*x2 <= 47)
    m.addConstr(7.56*x0 + 2.11*x1 + 1.96*x2 <= 47)
    m.addConstr(0.52*x0 + 7.81*x1 <= 89)
    m.addConstr(0.52*x0 + 1.78*x2 <= 89)
    m.addConstr(0.52*x0 + 7.81*x1 + 1.78*x2 <= 89)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
