
import gurobi

def optimize():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="milligrams_of_calcium", lb=-gurobi.GRB.INFINITY)
    x2 = model.addVar(name="grams_of_fiber", lb=-gurobi.GRB.INFINITY)
    x3 = model.addVar(name="grams_of_protein", lb=-gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(3*x1 + x2 + 3*x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3.18*x1 <= 107)
    model.addConstr(3.69*x1 <= 78)
    model.addConstr(7.56*x1 <= 64)
    model.addConstr(0.52*x1 <= 123)

    model.addConstr(7.91*x2 <= 107)
    model.addConstr(6.97*x2 <= 78)
    model.addConstr(2.11*x2 <= 64)
    model.addConstr(7.81*x2 <= 123)

    model.addConstr(1.06*x3 <= 107)
    model.addConstr(7.41*x3 <= 78)
    model.addConstr(1.96*x3 <= 64)
    model.addConstr(1.78*x3 <= 123)

    model.addConstr(3.18*x1 + 7.91*x2 >= 16)
    model.addConstr(6.97*x2 + 7.41*x3 >= 15)
    model.addConstr(7.91*x2 + 1.06*x3 <= 57)
    model.addConstr(3.18*x1 + 7.91*x2 <= 90)
    model.addConstr(3.18*x1 + 7.91*x2 + 1.06*x3 <= 90)

    model.addConstr(3.69*x1 + 7.41*x3 <= 37)
    model.addConstr(6.97*x2 + 7.41*x3 <= 57)
    model.addConstr(3.69*x1 + 6.97*x2 + 7.41*x3 <= 57)

    model.addConstr(7.56*x1 + 2.11*x2 <= 35)
    model.addConstr(7.56*x1 + 1.96*x3 <= 47)
    model.addConstr(7.56*x1 + 2.11*x2 + 1.96*x3 <= 47)

    model.addConstr(0.52*x1 + 7.81*x2 <= 89)
    model.addConstr(0.52*x1 + 1.78*x3 <= 89)
    model.addConstr(0.52*x1 + 7.81*x2 + 1.78*x3 <= 89)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("milligrams of calcium: ", x1.varValue)
        print("grams of fiber: ", x2.varValue)
        print("grams of protein: ", x3.varValue)
    else:
        print("The model is infeasible")

optimize()
