
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
iron = m.addVar(lb=0, name="iron")
zinc = m.addVar(lb=0, name="zinc")
vitamin_b3 = m.addVar(lb=0, name="vitamin_b3")

# Set objective function
m.setObjective(3.22 * iron + 4.92 * zinc + 5.32 * vitamin_b3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3 * iron + 13 * zinc >= 59)
m.addConstr(13 * zinc + 6 * vitamin_b3 >= 31)
m.addConstr(3 * iron + 13 * zinc + 6 * vitamin_b3 >= 31)
m.addConstr(7 * iron + 13 * zinc >= 42)
m.addConstr(7 * iron + 13 * zinc + 10 * vitamin_b3 >= 42)
m.addConstr(1 * iron + 4 * vitamin_b3 >= 63)
m.addConstr(18 * zinc + 4 * vitamin_b3 >= 79)
m.addConstr(1 * iron + 18 * zinc >= 36)
m.addConstr(1 * iron + 18 * zinc + 4 * vitamin_b3 >= 36)
m.addConstr(17 * zinc + 7 * vitamin_b3 >= 23)
m.addConstr(16 * iron + 17 * zinc >= 34)
m.addConstr(16 * iron + 17 * zinc + 7 * vitamin_b3 >= 34)
m.addConstr(-10 * iron + 4 * vitamin_b3 >= 0)
m.addConstr(2 * zinc - 1 * vitamin_b3 >= 0)
m.addConstr(3 * iron + 13 * zinc <= 125)
m.addConstr(3 * iron + 13 * zinc + 6 * vitamin_b3 <= 86)
m.addConstr(7 * iron + 13 * zinc + 10 * vitamin_b3 <= 99)
m.addConstr(1 * iron + 18 * zinc <= 179)
m.addConstr(1 * iron + 4 * vitamin_b3 <= 170)
m.addConstr(16 * iron + 7 * vitamin_b3 <= 102)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

