
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="milligrams of iron", lb=0)
x2 = m.addVar(name="milligrams of zinc", lb=0)
x3 = m.addVar(name="milligrams of vitamin B3", lb=0)

# Define the objective function
m.setObjective(3.22*x1 + 4.92*x2 + 5.32*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x1 <= 228)
m.addConstr(7*x1 <= 271)
m.addConstr(1*x1 <= 270)
m.addConstr(16*x1 <= 130)
m.addConstr(13*x2 <= 228)
m.addConstr(13*x2 <= 271)
m.addConstr(18*x2 <= 270)
m.addConstr(17*x2 <= 130)
m.addConstr(6*x3 <= 228)
m.addConstr(10*x3 <= 271)
m.addConstr(4*x3 <= 270)
m.addConstr(7*x3 <= 130)
m.addConstr(3*x1 + 13*x2 >= 59)
m.addConstr(13*x2 + 6*x3 >= 31)
m.addConstr(3*x1 + 13*x2 + 6*x3 >= 31)
m.addConstr(7*x1 + 13*x2 >= 42)
m.addConstr(7*x1 + 13*x2 + 10*x3 >= 42)
m.addConstr(1*x1 + 4*x3 >= 63)
m.addConstr(18*x2 + 4*x3 >= 79)
m.addConstr(1*x1 + 18*x2 >= 36)
m.addConstr(1*x1 + 18*x2 + 4*x3 >= 36)
m.addConstr(17*x2 + 7*x3 >= 23)
m.addConstr(16*x1 + 17*x2 >= 34)
m.addConstr(16*x1 + 17*x2 + 7*x3 >= 34)
m.addConstr(-10*x1 + 4*x3 >= 0)
m.addConstr(2*x2 - 1*x3 >= 0)
m.addConstr(3*x1 + 13*x2 <= 125)
m.addConstr(3*x1 + 13*x2 + 6*x3 <= 86)
m.addConstr(7*x1 + 13*x2 + 10*x3 <= 99)
m.addConstr(1*x1 + 18*x2 <= 179)
m.addConstr(1*x1 + 4*x3 <= 170)
m.addConstr(16*x1 + 7*x3 <= 102)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Milligrams of iron: ", x1.varValue)
    print("Milligrams of zinc: ", x2.varValue)
    print("Milligrams of vitamin B3: ", x3.varValue)
    print("Objective function value: ", m.objVal)
else:
    print("No optimal solution found.")
