
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("napkins_and_paper_towels")

    # Create variables
    napkins = m.addVar(vtype=gp.GRB.INTEGER, name="napkins")
    paper_towels = m.addVar(vtype=gp.GRB.INTEGER, name="paper_towels")


    # Set objective function
    m.setObjective(4.42 * napkins + 5.02 * paper_towels, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(7 * napkins + 8 * paper_towels >= 16, "value_min")
    m.addConstr(-5 * napkins + 3 * paper_towels >= 0, "ratio")
    m.addConstr(7 * napkins + 8 * paper_towels <= 39, "value_max")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print solution
        print("Optimal Solution:")
        print(f"Packs of Napkins: {napkins.x}")
        print(f"Paper Towel Rolls: {paper_towels.x}")
        print(f"Objective Value: {m.objVal}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
