
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x1 = m.addVar(vtype=GRB.INTEGER, name="packs_of_napkins")
x2 = m.addVar(vtype=GRB.INTEGER, name="paper_towel_rolls")

# Set the objective function
m.setObjective(4.42*x1 + 5.02*x2, GRB.MINIMIZE)

# Add constraints to the model
m.addConstr(7*x1 + 8*x2 >= 16, "combined_value_at_least")
m.addConstr(-5*x1 + 3*x2 >= 0, "napkins_and_rolls_constraint")
m.addConstr(7*x1 + 8*x2 <= 39, "total_value_not_exceed")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Packs of Napkins: {x1.x}")
    print(f"Paper Towel Rolls: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
