
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="packs_of_napkins", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="paper_towel_rolls", vtype=gurobi.GRB.INTEGER)

    # Objective function: minimize 4.42*x1 + 5.02*x2
    model.setObjective(4.42*x1 + 5.02*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(7*x1 + 8*x2 >= 16)
    model.addConstr(-5*x1 + 3*x2 >= 0)
    model.addConstr(7*x1 + 8*x2 <= 39)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Packs of napkins: {x1.varValue}")
        print(f"Paper towel rolls: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
