
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_model")

# Create variables
x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="ham_sandwiches")
x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="corn_cobs")
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="kiwis")
x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="chicken_thighs")


# Set objective function
m.setObjective(7*x0*x1 + 3*x0*x3 + 5*x1*x2 + 6*x1*x3 + 3*x2**2 + 2*x1 + 3*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(17*x0 + 20*x1 + 1*x2 + 9*x3 <= 436, "calcium_upper_bound")
m.addConstr(17*x0**2 + 20*x1**2 >= 92, "calcium_constraint1")
m.addConstr(20*x1 + 1*x2 >= 96, "calcium_constraint2")
m.addConstr(17*x0**2 + 9*x3**2 >= 79, "calcium_constraint3")
m.addConstr(17*x0 + 20*x1 + 9*x3 >= 82, "calcium_constraint4")
m.addConstr(17*x0**2 + 20*x1**2 + 1*x2**2 >= 82, "calcium_constraint5")
m.addConstr(17*x0 + 20*x1 + 9*x3 >= 90, "calcium_constraint6")
m.addConstr(17*x0 + 20*x1 + 1*x2 >= 90, "calcium_constraint7")
m.addConstr(20*x1 + 9*x3 <= 198, "calcium_constraint8")
m.addConstr(1*x2 + 9*x3 <= 164, "calcium_constraint9")
m.addConstr(17*x0 + 9*x3 <= 237, "calcium_constraint10")
m.addConstr(17*x0 + 20*x1 + 1*x2 + 9*x3 <= 237, "calcium_constraint11")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

