
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=GRB.INTEGER, name="hours worked by Ringo")
    x1 = model.addVar(vtype=GRB.CONTINUOUS, name="hours worked by Laura")

    # Set objective function
    model.setObjective(4*x0**2 + 5*x0*x1 + 8*x1**2 + 2*x0 + x1, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(1.93*x0**2 + 2.47*x1**2 >= 16, "c0")
    model.addConstr(0.18*x0**2 + 2.89*x1**2 >= 21, "c1")
    model.addConstr(1.96*x0**2 + 0.25*x1**2 >= 25, "c2")
    model.addConstr(2.25*x0 + 0.77*x1 >= 6, "c3")
    model.addConstr(-4*x0 + 10*x1 >= 0, "c4")
    model.addConstr(1.93*x0**2 + 2.47*x1**2 <= 25, "c5")
    model.addConstr(1.93*x0 + 2.47*x1 <= 25, "c6")
    model.addConstr(0.18*x0**2 + 2.89*x1**2 <= 92, "c7")
    model.addConstr(0.18*x0 + 2.89*x1 <= 92, "c8")
    model.addConstr(1.96*x0**2 + 0.25*x1**2 <= 109, "c9")
    model.addConstr(1.96*x0 + 0.25*x1 <= 109, "c10")
    model.addConstr(2.25*x0 + 0.77*x1 <= 24, "c11")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
    elif model.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
