
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="hours_worked_by_Ringo", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="hours_worked_by_Laura")

# Define the objective function
m.setObjective(4*x1**2 + 5*x1*x2 + 8*x2**2 + 2*x1 + x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1.93*x1 <= 35)
m.addConstr(0.18*x1 <= 101)
m.addConstr(1.96*x1 <= 116)
m.addConstr(2.25*x1 <= 26)
m.addConstr(2.47*x2 <= 35)
m.addConstr(2.89*x2 <= 101)
m.addConstr(0.25*x2 <= 116)
m.addConstr(0.77*x2 <= 26)
m.addConstr(1.93*x1**2 + 2.47*x2**2 >= 16)
m.addConstr(0.18*x1**2 + 2.89*x2**2 >= 21)
m.addConstr(1.96*x1**2 + 0.25*x2**2 >= 25)
m.addConstr(2.25*x1 + 0.77*x2 >= 6)
m.addConstr(-4*x1 + 10*x2 >= 0)
m.addConstr(1.93*x1**2 + 2.47*x2**2 <= 25)
m.addConstr(1.93*x1 + 2.47*x2 <= 25)
m.addConstr(0.18*x1**2 + 2.89*x2**2 <= 92)
m.addConstr(0.18*x1 + 2.89*x2 <= 92)
m.addConstr(1.96*x1**2 + 0.25*x2**2 <= 109)
m.addConstr(1.96*x1 + 0.25*x2 <= 109)
m.addConstr(2.25*x1 + 0.77*x2 <= 24)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by Ringo: ", x1.varValue)
    print("Hours worked by Laura: ", x2.varValue)
else:
    print("The problem is infeasible")
