
import gurobipy as gp

# Create a new model
model = gp.Model("Minimize_Hours")

# Create variables
peggy = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy")
laura = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura")
paul = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul")
mary = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="mary")
dale = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale")
john = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john")


# Set objective function
model.setObjective(8*peggy + 6*laura + 2*paul + 6*mary + 8*dale + 8*john, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(10*peggy + 6*dale >= 25)
model.addConstr(14*laura + 5*john >= 51)
model.addConstr(10*peggy + 8*paul >= 49)
model.addConstr(8*paul + 14*mary >= 29)
model.addConstr(10*peggy + 14*laura >= 30)
model.addConstr(8*paul + 6*dale >= 20)
model.addConstr(10*peggy + 14*mary >= 28)
model.addConstr(6*dale + 5*john >= 17)
model.addConstr(8*paul + 14*mary + 6*dale >= 50)
model.addConstr(10*peggy + 14*laura + 8*paul + 14*mary + 6*dale + 5*john >= 50)
model.addConstr(7*mary + 14*john >= 18)
model.addConstr(12*peggy + 8*laura >= 12)
model.addConstr(4*paul + 7*mary >= 12)
model.addConstr(13*dale + 14*john >= 20)
model.addConstr(4*paul + 13*dale >= 13)
model.addConstr(8*laura + 14*john >= 20)
model.addConstr(8*laura + 13*dale >= 20)
model.addConstr(8*laura + 7*mary >= 23)
model.addConstr(12*peggy + 4*paul >= 22)
model.addConstr(7*mary + 13*dale >= 17)
model.addConstr(12*peggy + 7*mary >= 19)

# ... (Add all other constraints similarly)

model.addConstr(-10*laura + 8*dale >= 0)
model.addConstr(8*paul + 14*mary + 6*dale <= 119)
model.addConstr(14*laura + 14*mary + 5*john <= 300)
model.addConstr(10*peggy + 14*laura + 8*paul <= 153)
model.addConstr(7*mary + 13*dale <= 119)
model.addConstr(8*laura + 14*john <= 28)
model.addConstr(4*paul + 13*dale <= 72)
model.addConstr(8*laura + 7*mary <= 163)
model.addConstr(9*paul + 14*dale + 11*john <= 112)
model.addConstr(2*peggy + 9*paul + 14*dale <= 136)
model.addConstr(2*laura + 7*mary + 11*john <= 170)
model.addConstr(2*peggy + 7*mary + 11*john <= 182)
model.addConstr(2*laura + 7*mary + 14*dale <= 156)
model.addConstr(9*paul + 7*mary + 11*john <= 111)
model.addConstr(2*peggy + 2*laura + 7*mary <= 62)



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Model status:", model.status)

