
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Optimization")

# Create variables
bill = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Bill")
laura = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Laura")
peggy = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Peggy")
john = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="John")
dale = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Dale")
paul = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Paul")


# Set objective function
model.setObjective(9*bill**2 + 6*bill*laura + 2*bill*dale + 3*laura*peggy + 7*laura*paul + 7*peggy*dale + 9*peggy*paul + 6*john**2 + 4*john*dale + 7*bill + 1*peggy + 3*john + 9*dale + 7*paul, gp.GRB.MAXIMIZE)

# Add constraints -  likelihood to quit index
model.addConstr(19*laura + 9*paul >= 52)
model.addConstr(6*bill + 19*laura >= 56)
model.addConstr(14*john**2 + 9*paul**2 >= 21)
# ... (add all other constraints from the JSON "constraints" field)
model.addConstr(14*bill + 26*paul >= 124)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Bill:', bill.x)
    print('Laura:', laura.x)
    print('Peggy:', peggy.x)
    print('John:', john.x)
    print('Dale:', dale.x)
    print('Paul:', paul.x)

elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

