
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(name="hours_worked_by_Bill", lb=0)
x2 = m.addVar(name="hours_worked_by_Laura", lb=0)
x3 = m.addVar(name="hours_worked_by_Peggy", lb=0)
x4 = m.addVar(name="hours_worked_by_John", lb=0)
x5 = m.addVar(name="hours_worked_by_Dale", lb=0)
x6 = m.addVar(name="hours_worked_by_Paul", lb=0)

# Define constraints
m.addConstr(x1 + x2 >= 124, name="paperwork_competence_constraint_1")
m.addConstr(x3**2 + x6**2 >= 149, name="paperwork_competence_constraint_2")
m.addConstr(x1 * x6 <= 103, name="likelihood_to_quit_index_constraint_1")
m.addConstr(x3 * x4 <= 249, name="likelihood_to_quit_index_constraint_2")
m.addConstr(x1 * x2 <= 229, name="likelihood_to_quit_index_constraint_3")
m.addConstr(x2 * x5 <= 268, name="likelihood_to_quit_index_constraint_4")
m.addConstr(x3 * x5 <= 336, name="likelihood_to_quit_index_constraint_5")
m.addConstr(x4 * x5 <= 172, name="likelihood_to_quit_index_constraint_6")
m.addConstr(x2 + x4 <= 140, name="likelihood_to_quit_index_constraint_7")
m.addConstr(x2 + x6 <= 164, name="likelihood_to_quit_index_constraint_8")

# Since there is no objective function defined in the problem,
# we will use a simple objective function for demonstration purposes
m.setObjective(x1 + x2 + x3 + x4 + x5 + x6, GRB.MINIMIZE)

# Solve the model
m.optimize()
