
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(name="vitamin_B1", lb=0)  # milligrams of vitamin B1
    x1 = m.addVar(name="vitamin_C", lb=0)  # milligrams of vitamin C
    x2 = m.addVar(name="potassium", lb=0)  # milligrams of potassium


    # Set objective function
    m.setObjective(4*x0 + 5*x1 + 5*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(8*x0 + 19*x1 >= 55, "c1")
    m.addConstr(19*x1 + 6*x2 >= 41, "c2")
    m.addConstr(8*x0 + 19*x1 + 6*x2 >= 41, "c3")
    m.addConstr(x0 - 8*x2 >= 0, "c4")
    m.addConstr(19*x1 + 6*x2 <= 295, "c5")
    m.addConstr(8*x0 + 6*x2 <= 151, "c6")
    m.addConstr(8*x0 + 19*x1 + 6*x2 <= 287, "c7")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Vitamin B1: %g' % x0.x)
        print('Vitamin C: %g' % x1.x)
        print('Potassium: %g' % x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
