
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='x1', lb=-gurobi.GRB.INFINITY)  # milligrams of vitamin B1
    x2 = model.addVar(name='x2', lb=-gurobi.GRB.INFINITY)  # milligrams of vitamin C
    x3 = model.addVar(name='x3', lb=-gurobi.GRB.INFINITY)  # milligrams of potassium

    # Define the objective function
    model.setObjective(4 * x1 + 5 * x2 + 5 * x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(8 * x1 + 19 * x2 >= 55)
    model.addConstr(19 * x2 + 6 * x3 >= 41)
    model.addConstr(8 * x1 + 19 * x2 + 6 * x3 >= 41)
    model.addConstr(x1 - 8 * x3 >= 0)
    model.addConstr(19 * x2 + 6 * x3 <= 295)
    model.addConstr(8 * x1 + 6 * x3 <= 151)
    model.addConstr(8 * x1 + 19 * x2 + 6 * x3 <= 287)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('x1: ', x1.x)
        print('x2: ', x2.x)
        print('x3: ', x3.x)
    else:
        print('The model is infeasible')

solve_optimization_problem()
