
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    dale = model.addVar(vtype=gp.GRB.INTEGER, name="dale")
    mary = model.addVar(vtype=gp.GRB.INTEGER, name="mary")
    peggy = model.addVar(vtype=gp.GRB.INTEGER, name="peggy")
    hank = model.addVar(vtype=gp.GRB.INTEGER, name="hank")
    bill = model.addVar(vtype=gp.GRB.INTEGER, name="bill")


    # Set objective function
    model.setObjective(4 * dale + 8 * mary + 6 * peggy + 9 * hank + 7 * bill, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(1.04 * mary + 5.57 * hank >= 41)
    model.addConstr(1.04 * mary + 5.86 * peggy >= 21)
    model.addConstr(2.32 * dale + 1.04 * mary >= 29)
    model.addConstr(5.86 * peggy + 2.05 * bill >= 39)
    model.addConstr(5.57 * hank + 2.05 * bill >= 17)
    model.addConstr(1.04 * mary + 5.57 * hank <= 206)
    model.addConstr(2.32 * dale + 2.05 * bill <= 99)
    model.addConstr(2.32 * dale + 1.04 * mary <= 193)
    model.addConstr(2.32 * dale + 5.86 * peggy <= 148)
    model.addConstr(1.04 * mary + 5.86 * peggy + 5.57 * hank <= 107)
    model.addConstr(2.32 * dale + 1.04 * mary + 5.86 * peggy + 5.57 * hank + 2.05 * bill <= 107)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
