
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name='x1', vtype='I')  # hours worked by Dale
x2 = model.addVar(name='x2', vtype='I')  # hours worked by Mary
x3 = model.addVar(name='x3', vtype='I')  # hours worked by Peggy
x4 = model.addVar(name='x4', vtype='I')  # hours worked by Hank
x5 = model.addVar(name='x5', vtype='I')  # hours worked by Bill

# Define the objective function
model.setObjective(4 * x1 + 8 * x2 + 6 * x3 + 9 * x4 + 7 * x5, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(1.04 * x2 + 5.57 * x4 >= 41)
model.addConstr(1.04 * x2 + 5.86 * x3 >= 21)
model.addConstr(2.32 * x1 + 1.04 * x2 >= 29)
model.addConstr(5.86 * x3 + 2.05 * x5 >= 39)
model.addConstr(5.57 * x4 + 2.05 * x5 >= 17)
model.addConstr(1.04 * x2 + 5.57 * x4 <= 206)
model.addConstr(2.32 * x1 + 2.05 * x5 <= 99)
model.addConstr(2.32 * x1 + 1.04 * x2 <= 193)
model.addConstr(2.32 * x1 + 5.86 * x3 <= 148)
model.addConstr(1.04 * x2 + 5.86 * x3 + 5.57 * x4 <= 107)
model.addConstr(2.32 * x1 + 1.04 * x2 + 5.86 * x3 + 5.57 * x4 + 2.05 * x5 <= 224)

# Update model
model.update()

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objVal)
    print('x1: ', x1.varValue)
    print('x2: ', x2.varValue)
    print('x3: ', x3.varValue)
    print('x4: ', x4.varValue)
    print('x5: ', x5.varValue)
else:
    print('The model is infeasible')
