
import gurobipy as gp

# Create a new model
model = gp.Model("nutrition_optimization")

# Create variables
carbohydrates = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="carbohydrates")
vitamin_b12 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b12")
vitamin_d = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_d")

# Set objective function
model.setObjective(4 * carbohydrates + 6 * vitamin_b12 + 3 * vitamin_d, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(18 * carbohydrates + 21 * vitamin_b12 + 2 * vitamin_d <= 222, "muscle_growth_index_limit")
model.addConstr(13 * carbohydrates + 9 * vitamin_b12 + 23 * vitamin_d <= 236, "energy_stability_index_limit")
model.addConstr(5 * carbohydrates + 15 * vitamin_b12 + 10 * vitamin_d <= 167, "immune_support_index_limit")
model.addConstr(21 * carbohydrates + 5 * vitamin_b12 + 8 * vitamin_d <= 173, "cognitive_performance_index_limit")

model.addConstr(21 * vitamin_b12 + 2 * vitamin_d >= 47, "muscle_growth_b12_d")
model.addConstr(18 * carbohydrates + 2 * vitamin_d >= 48, "muscle_growth_carbohydrates_d")
model.addConstr(18 * carbohydrates + 21 * vitamin_b12 + 2 * vitamin_d >= 48, "muscle_growth_all")

model.addConstr(13 * carbohydrates + 23 * vitamin_d >= 39, "energy_stability_carbohydrates_d")
model.addConstr(9 * vitamin_b12 + 23 * vitamin_d >= 58, "energy_stability_b12_d")
model.addConstr(13 * carbohydrates + 9 * vitamin_b12 + 23 * vitamin_d >= 58, "energy_stability_all")

model.addConstr(5 * carbohydrates + 10 * vitamin_d >= 22, "immune_support_carbohydrates_d")
model.addConstr(5 * carbohydrates + 15 * vitamin_b12 >= 32, "immune_support_carbohydrates_b12")
model.addConstr(5 * carbohydrates + 15 * vitamin_b12 + 10 * vitamin_d >= 31, "immune_support_all")
model.addConstr(5 * carbohydrates + 15 * vitamin_b12 + 10 * vitamin_d >= 31, "immune_support_all2")


model.addConstr(21 * carbohydrates + 8 * vitamin_d >= 31, "cognitive_performance_carbohydrates_d")
model.addConstr(21 * carbohydrates + 5 * vitamin_b12 + 8 * vitamin_d >= 31, "cognitive_performance_all")

model.addConstr(-3 * carbohydrates + 7 * vitamin_d >= 0, "constraint_carbohydrates_d")
model.addConstr(10 * carbohydrates - 8 * vitamin_b12 >= 0, "constraint_carbohydrates_b12")

model.addConstr(5 * carbohydrates + 15 * vitamin_b12 + 10 * vitamin_d <= 56, "immune_support_upper")
model.addConstr(21 * carbohydrates + 5 * vitamin_b12 + 8 * vitamin_d <= 111, "cognitive_performance_upper")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Carbohydrates: {carbohydrates.x}")
    print(f"Vitamin B12: {vitamin_b12.x}")
    print(f"Vitamin D: {vitamin_d.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

