
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="x1", lb=0)  # grams of carbohydrates
x2 = m.addVar(name="x2", lb=0)  # milligrams of vitamin B12
x3 = m.addVar(name="x3", lb=0)  # milligrams of vitamin D

# Objective function
m.setObjective(4 * x1 + 6 * x2 + 3 * x3, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(18 * x1 == 18)
m.addConstr(13 * x1 == 13)
m.addConstr(5 * x1 == 5)
m.addConstr(21 * x1 == 21)
m.addConstr(21 * x2 == 21)
m.addConstr(9 * x2 == 9)
m.addConstr(15 * x2 == 15)
m.addConstr(5 * x2 == 5)
m.addConstr(2 * x3 == 2)
m.addConstr(23 * x3 == 23)
m.addConstr(10 * x3 == 10)
m.addConstr(8 * x3 == 8)
m.addConstr(21 * x2 + 2 * x3 >= 47)
m.addConstr(18 * x1 + 2 * x3 >= 48)
m.addConstr(18 * x1 + 21 * x2 + 2 * x3 >= 48)
m.addConstr(13 * x1 + 23 * x3 >= 39)
m.addConstr(9 * x2 + 23 * x3 >= 58)
m.addConstr(13 * x1 + 9 * x2 + 23 * x3 >= 58)
m.addConstr(5 * x1 + 10 * x3 >= 22)
m.addConstr(5 * x1 + 15 * x2 >= 32)
m.addConstr(5 * x1 + 15 * x2 + 10 * x3 >= 31)
m.addConstr(21 * x1 + 8 * x3 >= 31)
m.addConstr(21 * x1 + 5 * x2 + 8 * x3 >= 31)
m.addConstr(-3 * x1 + 7 * x3 >= 0)
m.addConstr(10 * x1 - 8 * x2 >= 0)
m.addConstr(5 * x1 + 15 * x2 + 10 * x3 <= 56)
m.addConstr(21 * x1 + 5 * x2 + 8 * x3 <= 111)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
