
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_model")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="x0") # hours worked by Peggy
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="x1") # hours worked by John
    x2 = model.addVar(vtype=gp.GRB.INTEGER, name="x2") # hours worked by Bobby
    x3 = model.addVar(vtype=gp.GRB.INTEGER, name="x3") # hours worked by Jean


    # Set objective function
    model.setObjective(1*x0 + 6*x1 + 8*x2 + 9*x3, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(8*x1 + 5*x3 >= 20)
    model.addConstr(10*x2 + 5*x3 >= 14)
    model.addConstr(8*x0 + 12*x1 >= 21)
    model.addConstr(8*x0 + 10*x2 >= 15)
    model.addConstr(8*x0 + 12*x1 + 10*x2 + 5*x3 >= 15)
    model.addConstr(12*x0 + 13*x1 >= 32)
    model.addConstr(13*x1 + 5*x3 >= 36)
    model.addConstr(6*x2 + 5*x3 >= 28)
    model.addConstr(12*x0 + 13*x1 + 6*x2 + 5*x3 >= 28)
    model.addConstr(7*x0 - 8*x3 >= 0)
    model.addConstr(10*x2 - 5*x3 >= 0)
    model.addConstr(8*x0 + 10*x2 <= 63)
    model.addConstr(10*x2 + 5*x3 <= 93)
    model.addConstr(8*x0 + 12*x1 <= 97)
    model.addConstr(8*x0 + 5*x3 <= 54)
    model.addConstr(12*x1 + 10*x2 <= 57)
    model.addConstr(8*x0 + 12*x1 + 10*x2 <= 56)
    model.addConstr(12*x1 + 10*x2 + 5*x3 <= 78)
    model.addConstr(12*x0 + 13*x1 + 5*x3 <= 95)
    model.addConstr(13*x1 + 6*x2 + 5*x3 <= 124)
    model.addConstr(12*x0 + 6*x2 + 5*x3 <= 164)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
