
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of potassium
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin B4
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # grams of protein
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3") # milligrams of magnesium


# Set objective function
m.setObjective(5*x0 + 5*x1 + 5*x2 + 3*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9*x0 + 4*x3 >= 4)
m.addConstr(9*x0 + 12*x2 >= 10)
m.addConstr(9*x0 + 6*x1 + 12*x2 + 4*x3 >= 10)
m.addConstr(6*x0 + 5*x2 >= 21)
m.addConstr(8*x1 + 5*x2 >= 9)
m.addConstr(5*x2 + 1*x3 >= 12)
m.addConstr(6*x0 + 5*x2 + 1*x3 >= 22)
m.addConstr(6*x0 + 8*x1 + 5*x2 >= 22)
m.addConstr(8*x1 + 5*x2 + 1*x3 >= 22)
m.addConstr(6*x0 + 5*x2 + 1*x3 >= 12)
m.addConstr(6*x0 + 8*x1 + 5*x2 >= 12)
m.addConstr(8*x1 + 5*x2 + 1*x3 >= 12)
m.addConstr(6*x0 + 5*x2 + 1*x3 >= 13)
m.addConstr(6*x0 + 8*x1 + 5*x2 >= 13)
m.addConstr(8*x1 + 5*x2 + 1*x3 >= 13)
m.addConstr(6*x0 + 8*x1 + 5*x2 + 1*x3 >= 13)
m.addConstr(8*x0 + 1*x2 >= 11)
m.addConstr(10*x1 + 1*x2 >= 23)
m.addConstr(8*x0 + 13*x3 >= 11)
m.addConstr(8*x0 + 1*x2 + 13*x3 >= 24)
m.addConstr(8*x0 + 10*x1 + 1*x2 >= 24)
m.addConstr(8*x0 + 1*x2 + 13*x3 >= 22)
m.addConstr(8*x0 + 10*x1 + 1*x2 >= 22)
m.addConstr(8*x0 + 10*x1 + 1*x2 + 13*x3 >= 22)
m.addConstr(-10*x0 + 9*x1 >= 0)
m.addConstr(9*x0 + 4*x3 <= 26)
m.addConstr(6*x1 + 12*x2 <= 51)
m.addConstr(9*x0 + 12*x2 <= 42)

# Resource constraints from the provided resource dictionary
m.addConstr(9*x0 + 6*x1 + 12*x2 + 4*x3 <= 57) # Kidney support
m.addConstr(6*x0 + 8*x1 + 5*x2 + 1*x3 <= 91) # Cognitive performance
m.addConstr(8*x0 + 10*x1 + 1*x2 + 13*x3 <= 104) # Cardiovascular support


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

