
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x = m.addVars(4, vtype=gp.GRB.INTEGER, name=["x0", "x1", "x2", "x3"])


    # Set objective function
    m.setObjective(1*x[0] + 7*x[1] + 3*x[2] + 4*x[3], gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(5*x[0] + 8*x[1] + 7*x[2] + 2*x[3] <= 32, "c0")
    m.addConstr(2*x[0] + 4*x[1] + 6*x[2] + 7*x[3] <= 77, "c1")
    m.addConstr(8*x[1] + 7*x[2] >= 4, "c2")
    m.addConstr(5*x[0] + 7*x[2] >= 8, "c3")
    m.addConstr(5*x[0] + 8*x[1] + 7*x[2] + 2*x[3] >= 8, "c4")
    m.addConstr(2*x[0] + 6*x[2] >= 10, "c5")
    m.addConstr(2*x[0] + 7*x[3] >= 11, "c6")
    m.addConstr(4*x[1] + 6*x[2] >= 10, "c7")
    m.addConstr(6*x[2] + 7*x[3] >= 13, "c8")
    m.addConstr(2*x[0] + 4*x[1] + 7*x[3] >= 14, "c9")
    m.addConstr(4*x[1] + 6*x[2] + 7*x[3] >= 14, "c10")
    m.addConstr(2*x[0] + 4*x[1] + 7*x[3] >= 13, "c11")
    m.addConstr(4*x[1] + 6*x[2] + 7*x[3] >= 13, "c12")
    m.addConstr(2*x[0] + 4*x[1] + 6*x[2] + 7*x[3] >= 13, "c13")
    m.addConstr(4*x[0] - 8*x[2] >= 0, "c14")
    m.addConstr(-8*x[0] + 10*x[1] >= 0, "c15")
    m.addConstr(8*x[1] + 2*x[3] <= 12, "c16")
    m.addConstr(5*x[0] + 8*x[1] <= 20, "c17")
    m.addConstr(6*x[2] + 7*x[3] <= 53, "c18")
    m.addConstr(2*x[0] + 7*x[3] <= 72, "c19")
    m.addConstr(2*x[0] + 6*x[2] <= 46, "c20")
    m.addConstr(4*x[1] + 6*x[2] <= 46, "c21")
    m.addConstr(2*x[0] + 4*x[1] + 7*x[3] <= 19, "c22")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % m.objVal)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
