
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # cartons of milk
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # packs of napkins
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # paper towel rolls
    x3 = model.addVar(name="x3", vtype=gurobi.GRB.INTEGER)  # cookies

    # Objective function
    model.setObjective(1 * x0 + 7 * x1 + 3 * x2 + 4 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(8 * x1 + 7 * x2 >= 4)
    model.addConstr(5 * x0 + 7 * x2 >= 8)
    model.addConstr(5 * x0 + 8 * x1 + 7 * x2 + 2 * x3 >= 8)
    model.addConstr(2 * x0 + 6 * x2 >= 10)
    model.addConstr(2 * x0 + 7 * x3 >= 11)
    model.addConstr(4 * x1 + 6 * x2 >= 10)
    model.addConstr(6 * x2 + 7 * x3 >= 13)
    model.addConstr(2 * x0 + 4 * x1 + 7 * x3 >= 14)
    model.addConstr(4 * x1 + 6 * x2 + 7 * x3 >= 14)
    model.addConstr(2 * x0 + 4 * x1 + 7 * x3 >= 13)
    model.addConstr(2 * x0 + 4 * x1 + 6 * x2 + 7 * x3 >= 13)
    model.addConstr(4 * x0 - 8 * x2 >= 0)
    model.addConstr(-8 * x0 + 10 * x1 >= 0)
    model.addConstr(8 * x1 + 2 * x3 <= 12)
    model.addConstr(5 * x0 + 8 * x1 <= 20)
    model.addConstr(6 * x2 + 7 * x3 <= 53)
    model.addConstr(2 * x0 + 7 * x3 <= 72)
    model.addConstr(2 * x0 + 6 * x2 <= 46)
    model.addConstr(4 * x1 + 6 * x2 <= 46)
    model.addConstr(2 * x0 + 4 * x1 + 7 * x3 <= 19)
    model.addConstr(5 * x0 + 8 * x1 + 7 * x2 + 2 * x3 <= 32)
    model.addConstr(2 * x0 + 4 * x1 + 6 * x2 + 7 * x3 <= 77)

    # Solve the problem
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Objective: {model.objval}")
        print(f"cartons of milk: {x0.varValue}")
        print(f"packs of napkins: {x1.varValue}")
        print(f"paper towel rolls: {x2.varValue}")
        print(f"cookies: {x3.varValue}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The problem is infeasible.")
    else:
        print("The problem has no optimal solution.")

optimize_problem()
