
import gurobipy as gp

# Create a new model
m = gp.Model("diet_problem")

# Create variables
steaks = m.addVar(lb=0, name="steaks")
bowls_of_cereal = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="bowls_of_cereal")


# Set objective function
m.setObjective(7.99 * steaks + 4.73 * bowls_of_cereal, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * steaks + 7 * bowls_of_cereal >= 52, "iron_min")
m.addConstr(14 * steaks + 7 * bowls_of_cereal >= 60, "calcium_min")
m.addConstr(5 * steaks - 2 * bowls_of_cereal >= 0, "steak_cereal_ratio")
m.addConstr(8 * steaks + 7 * bowls_of_cereal <= 130, "iron_max")
m.addConstr(14 * steaks + 7 * bowls_of_cereal <= 129, "calcium_max")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective: %g' % m.objVal)
    print('Steaks:', steaks.x)
    print('Bowls of Cereal:', bowls_of_cereal.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

