
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="steaks")
x2 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="bowls_of_cereal")

# Set the objective function
m.setObjective(7.99*x1 + 4.73*x2, GRB.MINIMIZE)

# Add constraints to the model
m.addConstr(8*x1 + 7*x2 >= 52, "iron_lower_bound")
m.addConstr(14*x1 + 7*x2 >= 60, "calcium_lower_bound")
m.addConstr(5*x1 - 2*x2 >= 0, "linear_constraint")
m.addConstr(8*x1 + 7*x2 <= 130, "iron_upper_bound")
m.addConstr(14*x1 + 7*x2 <= 129, "calcium_upper_bound")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Steaks: {x1.x}")
    print(f"Bowls of cereal: {x2.x}")
else:
    print("No optimal solution found.")

