
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    steaks = model.addVar(name="steaks", lb=0)  # No lower bound specified, assuming 0
    bowls_of_cereal = model.addVar(name="bowls_of_cereal", lb=0, integrality=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(7.99 * steaks + 4.73 * bowls_of_cereal, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(8 * steaks + 7 * bowls_of_cereal >= 52, name="iron_min")
    model.addConstr(14 * steaks + 7 * bowls_of_cereal >= 60, name="calcium_min")
    model.addConstr(5 * steaks - 2 * bowls_of_cereal >= 0, name="steak_cereal_ratio")
    model.addConstr(8 * steaks + 7 * bowls_of_cereal <= 130, name="iron_max")
    model.addConstr(14 * steaks + 7 * bowls_of_cereal <= 129, name="calcium_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Steaks: {steaks.varValue}")
        print(f"Bowls of cereal: {bowls_of_cereal.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
