
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
ravioli = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ravioli")
strawberries = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="strawberries")


# Set objective function
m.setObjective(2 * ravioli + 4 * strawberries, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(7 * ravioli + 6 * strawberries >= 26, "umami_min")
m.addConstr(5 * ravioli + 6 * strawberries >= 11, "sourness_min")
m.addConstr(2 * ravioli + 5 * strawberries >= 21, "calcium_min")
m.addConstr(1 * ravioli - 8 * strawberries >= 0, "ravioli_strawberries_relation")
m.addConstr(7 * ravioli + 6 * strawberries <= 84, "umami_max")
m.addConstr(5 * ravioli + 6 * strawberries <= 59, "sourness_max")
m.addConstr(2 * ravioli + 5 * strawberries <= 65, "calcium_max")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('ravioli:', ravioli.x)
    print('strawberries:', strawberries.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

