
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="ravioli")
x2 = m.addVar(vtype=GRB.INTEGER, name="strawberries")  # Ensure strawberries are integers

# Set objective function
m.setObjective(2*x1 + 4*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*x1 + 6*x2 >= 26, "umami_index_min")
m.addConstr(5*x1 + 6*x2 >= 11, "sourness_index_min")
m.addConstr(2*x1 + 5*x2 >= 21, "calcium_min")
m.addConstr(x1 - 8*x2 >= 0, "linear_constraint")
m.addConstr(7*x1 + 6*x2 <= 84, "umami_index_max")
m.addConstr(5*x1 + 6*x2 <= 59, "sourness_index_max")
m.addConstr(2*x1 + 5*x2 <= 65, "calcium_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Ravioli: {x1.x}, Strawberries: {x2.x}")
else:
    print("No optimal solution found.")
