
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="ravioli", lb=0)  # ravioli can be non-negative
x2 = model.addVar(name="strawberries", lb=0, integrality=gurobi.GRB.INTEGER)  # strawberries must be an integer

# Define the objective function
model.setObjective(2 * x1 + 4 * x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(7 * x1 + 6 * x2 >= 26)  # minimum combined umami index
model.addConstr(5 * x1 + 6 * x2 >= 11)  # minimum combined sourness index
model.addConstr(2 * x1 + 5 * x2 >= 21)  # minimum combined milligrams of calcium
model.addConstr(x1 - 8 * x2 >= 0)  # relationship between ravioli and strawberries
model.addConstr(7 * x1 + 6 * x2 <= 84)  # maximum combined umami index
model.addConstr(5 * x1 + 6 * x2 <= 59)  # maximum combined sourness index
model.addConstr(2 * x1 + 5 * x2 <= 65)  # maximum combined milligrams of calcium

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Ravioli: {x1.varValue}")
    print(f"Strawberries: {x2.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
