
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Minimize_Work_Hours")

    # Create variables
    ringo_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")  # hours worked by Ringo
    bobby_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")  # hours worked by Bobby


    # Set objective function
    model.setObjective(3.18 * ringo_hours + 2.93 * bobby_hours, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(9 * ringo_hours + 10 * bobby_hours >= 53, "c0")
    model.addConstr(2 * ringo_hours + 5 * bobby_hours >= 27, "c1")
    model.addConstr(-6 * ringo_hours + 10 * bobby_hours >= 0, "c2")
    model.addConstr(9 * ringo_hours + 10 * bobby_hours <= 110, "c3")
    model.addConstr(2 * ringo_hours + 5 * bobby_hours <= 73, "c4")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Hours worked by Ringo: {ringo_hours.x}")
        print(f"Hours worked by Bobby: {bobby_hours.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Gurobi Error: {e}")

except Exception as e:
    print(f"Error: {e}")

